/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.security;

import de.willuhn.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Checksum {
    public static final String SHA1 = "SHA1";
    public static final String SHA256 = "SHA-256";
    public static final String MD5 = "MD5";

    private Checksum() {
    }

    public static String md5(byte[] text) throws NoSuchAlgorithmException {
        return Base64.encode(Checksum.checksum(text, MD5));
    }

    public static byte[] checksum(byte[] text, String alg) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(alg);
        return md.digest(text);
    }

    public static byte[] checksum(InputStream data, String alg) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance(alg);
        byte[] buf = new byte[4096];
        int read = 0;
        while ((read = data.read(buf)) != -1) {
            md.update(buf, 0, read);
        }
        return md.digest();
    }
}

